import os
import argparse
import json
import os
import sys
llava_path = os.path.dirname(os.path.dirname(os.path.dirname(__file__)))
if llava_path not in sys.path:
    sys.path.append(llava_path)
    print(sys.path)

from llava.eval.m4c_evaluator import EvalAIAnswerProcessor
from azfuse import File
from tqdm import tqdm

def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--annotation-file', type=str, required=True)
    parser.add_argument('--result-file', type=str, required=True)
    parser.add_argument('--result-upload-file', type=str, required=True)
    return parser.parse_args()


if __name__ == '__main__':

    args = parse_args()

    os.makedirs(os.path.dirname(args.result_upload_file), exist_ok=True)

    results = []
    error_line = 0
    for line_idx, line in enumerate(File.open(args.result_file)):
        try:
            results.append(json.loads(line))
        except:
            error_line += 1
    for x in results:
        if 'i don' in x['text']:
            x['text'] = 'unasnwerable'
        elif 'unanswerable' in x['text']:
            x['text'] = 'unasnwerable'
    results = {x['question_id']: x['text'] for x in results}
    test_split = [json.loads(line) for line in File.open(args.annotation_file)]
    split_ids = set([x['question_id'] for x in test_split])

    print(f'total results: {len(results)}, total split: {len(test_split)}, error_line: {error_line}')

    all_answers = []

    answer_processor = EvalAIAnswerProcessor()

    for x in tqdm(test_split):
        assert x['question_id'] in results
        all_answers.append({
            'image': x['image'],
            'answer': answer_processor(results[x['question_id']])
        })

    with File.open(args.result_upload_file, 'w') as f:
        json.dump(all_answers, f)
